@echo off
SETLOCAL

REM Version 05.01.2019
REM ISB AG Christian Schwerdt
REM Historie: 
REM 05.01.2019 Initiale Erstellung
REM 09.01.2019 Erweiterung um CFG Dateien
REM 10.01.2019 Erweiterung um CFG,ENV,CMD Dateien im bin Ordner
REM 23.01.2019 Erweiterung um XML Dateien im update-service Ordner
REM 26.02.2019 Erweiterung um Install Ordner
REM 19.03.2019 Erweiterung Dienstinformationen
REM 09.04.2019 Erweiterung ESS
REM 29.04.2019 Erweiterung Client-Config auf Server
REM 24.07.2019 Erweiterung um Ordner update-service\service\database
REM 02.10.2019 Erweiterung um ESS build.info
REM 25.11.2019 Erweiterung um Windows-Protokolle Anwendung und System
REM 14.12.2020 Erweiterung nicht deutschsprachige Windows-Installation

SET VERSION=12

REM server oder client
SET TYP=client

REM Datum und Uhrzeit ermitteln

REM WMIC pruefen
WMIC.EXE Alias /? >NUL 2>&1 || GOTO wmic_error

FOR /F "skip=1 tokens=1-6" %%G IN ('WMIC Path Win32_LocalTime Get Day^,Hour^,Minute^,Month^,Second^,Year /Format:table') DO (
   IF "%%~L"=="" goto tokens_done
      set _yyyy=%%L
      set _mm=00%%J
      set _dd=00%%G
      set _hour=00%%H
      set _minute=00%%I
      set _second=00%%K
)
:tokens_done

:: Pad digits with leading zeros
      set _mm=%_mm:~-2%
      set _dd=%_dd:~-2%
      set _hour=%_hour:~-2%
      set _minute=%_minute:~-2%
      set _second=%_second:~-2%

:: Display the date/time in ISO 8601 format:
set SORTTIME=%_hour%%_minute%%_second%
set SORTDATE=%_yyyy%-%_mm%-%_dd%

GOTO done

:wmic_error
set t=%time%
set SORTTIME=%t:~0,2%%t:~3,2%%t:~6,2%
if "%SORTTIME:~0,1%"==" " set SORTTIME=0%SORTTIME:~1,6%
set d=%date%
set SORTDATE=%d:~-4%-%d:~3,2%-%d:~0,2%

:done

REM TMP_PATH ohne Backslash. Wird auch aus Dateiname verwendet!
SET TMP_PATH=info_%TYP%_%SORTDATE%_%SORTTIME%

REM Basispfad fuer Logs und Konfiguration
SET BASE_PATH=%TMP_PATH%\%TYP%

REM Nur fuer den Server notwendig
SET UPDATESERVICE_BASE_PATH=%BASE_PATH%\update-service
SET UPDATESERVICE_SERVICE_PATH=%UPDATESERVICE_BASE_PATH%\service
SET UPDATESERVICE_LAUNCHER_PATH=%UPDATESERVICE_BASE_PATH%\launcher
SET ESS_BASE_PATH=%BASE_PATH%\plugins\applications\ess
SET JRE_FULL_PATH=..\jre

SET XCOPY_PARAMS=/C /Q /Y
SET XCOPY_PARAMS_SUBDIR=/E %XCOPY_PARAMS%

echo Loesche altes Verzeichnis "%TMP_PATH%"
if exist %TMP_PATH% rmdir /S /Q %TMP_PATH% > nul
if exist %TMP_PATH% ping -n 2 127.0.0.1 > nul
if exist %TMP_PATH% rmdir /S /Q %TMP_PATH% > nul

echo Verzeichnis anlegen "%TMP_PATH%"
mkdir %TMP_PATH%

echo Version speichern
echo:%VERSION%> %TMP_PATH%\version.%VERSION%

echo Skript kopieren
mkdir %TMP_PATH%\sonstiges
xcopy /C %0 %TMP_PATH%\sonstiges\%~n0%~x0.txt*

echo Verzeichnisse und Dateien auflisten und in Datei speichern
dir /N /S > %TMP_PATH%\files.txt

echo Installationsverzeichnis speichern
echo %cd% > %TMP_PATH%\installdir.txt

echo Systeminformationen speichern
systeminfo /FO LIST > %TMP_PATH%\systeminfo.txt

echo Umgebungsvariablen speichern
set > %TMP_PATH%\environment.txt

if /I "%TYP%"=="server" (
  REM Nur fuer den Server notwendig
  echo Windows-Protokolle Anwendung und System abfragen
  wevtutil epl Application %TMP_PATH%\Windows_Protokoll_Anwendung.evtx
  wevtutil epl System %TMP_PATH%\Windows_Protokoll_System.evtx
  )

if /I "%TYP%"=="server" (
  REM Nur fuer den Server notwendig
  echo Dienste abfragen
  sc queryex asv-server > %TMP_PATH%\dienst_asv-server.txt
  sc qc asv-server >> %TMP_PATH%\dienst_asv-server.txt
  sc queryex asv-update-service > %TMP_PATH%\dienst_asv-update-service.txt
  sc qc asv-update-service >> %TMP_PATH%\dienst_asv-update-service.txt
  )

echo Verzeichnisstruktur anlegen fuer Logs und Konfiguration
mkdir %BASE_PATH%
mkdir %BASE_PATH%\configuration
mkdir %BASE_PATH%\install
mkdir %BASE_PATH%\jre
mkdir %BASE_PATH%\logs

if /I "%TYP%"=="server" (
  REM Nur fuer den Server notwendig
  mkdir %BASE_PATH%\bin
  mkdir %BASE_PATH%\client
  mkdir %BASE_PATH%\plugins
  mkdir %BASE_PATH%\plugins\applications
  mkdir %ESS_BASE_PATH%
  mkdir %ESS_BASE_PATH%\config
  mkdir %ESS_BASE_PATH%\logs
  mkdir %ESS_BASE_PATH%\plugins
  mkdir %UPDATESERVICE_BASE_PATH%
  mkdir %UPDATESERVICE_LAUNCHER_PATH%
  mkdir %UPDATESERVICE_LAUNCHER_PATH%\bin
  mkdir %UPDATESERVICE_LAUNCHER_PATH%\logs
  mkdir %UPDATESERVICE_SERVICE_PATH%
  mkdir %UPDATESERVICE_SERVICE_PATH%\configuration
  mkdir %UPDATESERVICE_SERVICE_PATH%\database
  mkdir %UPDATESERVICE_SERVICE_PATH%\logs
  )

echo Java cfg kopieren
xcopy %XCOPY_PARAMS% ..\*.cfg %BASE_PATH%\
echo Konfiguration kopieren
xcopy %XCOPY_PARAMS% ..\configuration\*.* %BASE_PATH%\configuration\
echo Install kopieren
xcopy %XCOPY_PARAMS% ..\install\*.* %BASE_PATH%\install\
echo PFAD zum JAVA-Ordner auslesen aus jre.config
FOR /F "tokens=*" %%i IN (..\jre.cfg) DO (  set JRE_FULL_PATH=%%i)
echo JAVA Version kopieren
xcopy %XCOPY_PARAMS% %JRE_FULL_PATH%\release %BASE_PATH%\jre\


echo Logs kopieren
xcopy %XCOPY_PARAMS_SUBDIR% ..\logs\*.* %BASE_PATH%\logs\

if /I "%TYP%"=="server" (
  REM Nur fuer den Server notwendig
  echo cfg, env und cmd kopieren
  xcopy %XCOPY_PARAMS% ..\bin\*.cfg %BASE_PATH%\bin\
  xcopy %XCOPY_PARAMS% ..\bin\*.env %BASE_PATH%\bin\
  xcopy %XCOPY_PARAMS% ..\bin\*.cmd %BASE_PATH%\bin\
  echo Client Config kopieren
  xcopy %XCOPY_PARAMS_SUBDIR% ..\client\*.* %BASE_PATH%\client\
  )

if /I "%TYP%"=="server" (
  REM Nur fuer den Server notwendig
  echo Java cfg Launcher kopieren
  xcopy %XCOPY_PARAMS% ..\update-service\launcher\*.cfg %UPDATESERVICE_LAUNCHER_PATH%\
  echo cfg, env und cmd kopieren
  xcopy %XCOPY_PARAMS% ..\update-service\launcher\bin\*.cfg %UPDATESERVICE_LAUNCHER_PATH%\bin\
  xcopy %XCOPY_PARAMS% ..\update-service\launcher\bin\*.env %UPDATESERVICE_LAUNCHER_PATH%\bin\
  xcopy %XCOPY_PARAMS% ..\update-service\launcher\bin\*.cmd %UPDATESERVICE_LAUNCHER_PATH%\bin\
  echo Logs Update-Server Launcher kopieren
  xcopy %XCOPY_PARAMS_SUBDIR% ..\update-service\launcher\logs\*.* %UPDATESERVICE_LAUNCHER_PATH%\logs\
  )

if /I "%TYP%"=="server" (
  REM Nur fuer den Server notwendig
  echo Java cfg Update-Service kopieren
  xcopy %XCOPY_PARAMS% ..\update-service\service\*.cfg %UPDATESERVICE_SERVICE_PATH%\
  echo xml Update-Service kopieren
  xcopy %XCOPY_PARAMS% ..\update-service\service\*.xml %UPDATESERVICE_SERVICE_PATH%\
  echo Konfiguration Update-Service kopieren
  xcopy %XCOPY_PARAMS% ..\update-service\service\configuration\*.* %UPDATESERVICE_SERVICE_PATH%\configuration\
  echo Logs zur Datenbank kopieren
  xcopy %XCOPY_PARAMS% ..\update-service\service\database\*.* %UPDATESERVICE_SERVICE_PATH%\database\
  echo Logs Update-Service kopieren
  xcopy %XCOPY_PARAMS_SUBDIR% ..\update-service\service\logs\*.* %UPDATESERVICE_SERVICE_PATH%\logs\
  )

if /I "%TYP%"=="server" (
  REM Nur fuer den Server notwendig
  echo Startup Infos ESS kopieren
  xcopy %XCOPY_PARAMS% ..\plugins\applications\ess\*.* %ESS_BASE_PATH%\
  echo Konfiguration ESS kopieren
  xcopy %XCOPY_PARAMS_SUBDIR% ..\plugins\applications\ess\config\*.* %ESS_BASE_PATH%\config\
  echo Logs ESS kopieren
  xcopy %XCOPY_PARAMS_SUBDIR% ..\plugins\applications\ess\logs\*.* %ESS_BASE_PATH%\logs\
  echo build.info ESS kopieren
  xcopy %XCOPY_PARAMS_SUBDIR% ..\plugins\applications\ess\plugins\build.info %ESS_BASE_PATH%\plugins\
)

echo Suche ZIP Programm
SET ZIP=0
SET SEVEN_ZIP=0
SET ZIP_CMD=
if exist "%ProgramFiles%\7-Zip\7z.exe" (
  echo 7-Zip gefunden
  SET SEVEN_ZIP=1
  SET ZIP_CMD="%ProgramFiles%\7-Zip\7z.exe"
  )
if exist "%ProgramFiles(x86)%\7-Zip\7z.exe" (
  echo 7-Zip gefunden
  SET SEVEN_ZIP=1
  SET ZIP_CMD="%ProgramFiles(x86)%\7-Zip\7z.exe"
  )
if %SEVEN_ZIP%==1 (
  SET ZIP=1
  SET ZIP_CMD=%ZIP_CMD% a -tzip -bd %TMP_PATH% %TMP_PATH%\
  )

if %ZIP%==1 (
  echo ZIP Archiv erstellen
  %ZIP_CMD%
  rmdir /S /Q %TMP_PATH% > nul
  )
