#!/bin/sh

# Version 05.01.2019
# ISB AG Christian Schwerdt
# Historie: 
# 05.01.2019 Initiale Erstellung
# 09.01.2019 Erweiterung um CFG Dateien
# 10.01.2019 Erweiterung um CFG,ENV,CMD Dateien im bin Ordner
# 23.01.2019 Erweiterung um XML Dateien im update-service Ordner
# 19.02.2019 Linux-Version von nikolai
# 26.02.2019 Erweiterung um Install Ordner
# 09.04.2019 Erweiterung ESS
# 29.04.2019 Erweiterung Client-Config auf Server
# 24.07.2019 Erweiterung um Ordner update-service\service\database
# 02.10.2019 Erweiterung um ESS build.info
# 25.11.2019 Erweiterung um Windows-Protokolle Anwendung und System

VERSION=11

# server oder client
TYP=client

# Datum und Uhrzeit ermitteln
SORT_DATETIME=$(date +%Y-%m-%d_%H%M%S)

# TMP_PATH ohne Backslash. Wird auch aus Dateiname verwendet!
TMP_PATH=_info_${TYP}_${SORT_DATETIME}

# Basispfad fuer Logs und Konfiguration
BASE_PATH=$TMP_PATH/$TYP

# Nur fuer den Server notwendig
UPDATESERVICE_BASE_PATH=$BASE_PATH/update-service
UPDATESERVICE_SERVICE_PATH=$UPDATESERVICE_BASE_PATH/service
UPDATESERVICE_LAUNCHER_PATH=$UPDATESERVICE_BASE_PATH/launcher
ESS_BASE_PATH=$BASE_PATH/plugins/applications/ess

COPY_PARAMS=-f
COPY_PARAMS_SUBDIR=$COPY_PARAMS\ -r

JRE_FULL_PATH=..\jre

# Loesche altes Verzeichnis "$TMP_PATH"
if [ -d $TMP_PATH ]; then
	rm -rf $TMP_PATH
fi

echo Verzeichnis anlegen $TMP_PATH
mkdir $TMP_PATH

echo Version speichern
echo $VERSION> $TMP_PATH/version.$VERSION

echo Skript kopieren
mkdir $TMP_PATH/sonstiges
cp $COPY_PARAMS $0 $TMP_PATH/sonstiges

echo Verzeichnisse und Dateien auflisten und in Datei speichern
ls -AlR > $TMP_PATH/files.txt

echo Installationsverzeichnis speichern
echo $PWD > $TMP_PATH/installdir.txt

echo Systeminformationen speichern
uname -a > $TMP_PATH/systeminfo.txt
lshw >> $TMP_PATH/systeminfo.txt 2>&1

echo Umgebungsvariablen speichern
printenv > $TMP_PATH/environment.txt

if [ "$TYP" = "server" ]; then
  # Nur fuer den Server notwendig
  echo Dienste abfragen
  ps -ef | grep startup.jar  > $TMP_PATH/dienst_asv-server.txt
  ps -ef | grep startup.jar  > $TMP_PATH/dienst_asv-update-service.txt
fi

echo Verzeichnisstruktur anlegen fuer Logs und Konfiguration
mkdir $BASE_PATH
mkdir $BASE_PATH/configuration
mkdir $BASE_PATH/install
mkdir $BASE_PATH/jre
mkdir $BASE_PATH/logs

if  [ "$TYP" = "server" ]; then
  # Nur fuer den Server notwendig
  mkdir $BASE_PATH/bin
  mkdir $BASE_PATH/client
  mkdir $BASE_PATH/plugins
  mkdir $BASE_PATH/plugins/applications
  mkdir $ESS_BASE_PATH
  mkdir $ESS_BASE_PATH/config
  mkdir $ESS_BASE_PATH/logs
  mkdir $ESS_BASE_PATH/plugins
  mkdir $UPDATESERVICE_BASE_PATH
  mkdir $UPDATESERVICE_LAUNCHER_PATH
  mkdir $UPDATESERVICE_LAUNCHER_PATH/bin
  mkdir $UPDATESERVICE_LAUNCHER_PATH/logs
  mkdir $UPDATESERVICE_SERVICE_PATH
  mkdir $UPDATESERVICE_SERVICE_PATH/configuration
  mkdir $UPDATESERVICE_SERVICE_PATH/database
  mkdir $UPDATESERVICE_SERVICE_PATH/logs
fi
echo Launcher kopieren
find asv* -maxdepth 1 -type f -perm /a+x -exec cp {} $BASE_PATH/ \;
echo Java cfg kopieren
cp $COPY_PARAMS ../*.cfg $BASE_PATH/
echo Konfiguration kopieren
cp $COPY_PARAMS ../configuration/* $BASE_PATH/configuration/
echo Install kopieren
cp $COPY_PARAMS ../install/* $BASE_PATH/install/

echo jre.cfg auslesen
while read line 
do 
   JRE_FULL_PATH="$line" 
done < ../jre.cfg

echo JAVA Version kopieren
echo gesamter pfad zum relase:
echo $JRE_FULL_PATH/release
cp $COPY_PARAMS $JRE_FULL_PATH/release $BASE_PATH/jre/
echo Logs kopieren
cp $COPY_PARAMS_SUBDIR ../logs/* $BASE_PATH/logs/

if [ "$TYP" = "server" ]; then
  # Nur fuer den Server notwendig
  echo \"bin\" kopieren
  cp $COPY_PARAMS bin/* $BASE_PATH/bin/
  echo Client Config kopieren
  cp $COPY_PARAMS_SUBDIR client/* $BASE_PATH/client/
fi

if [ "$TYP" = "server" ]; then
  # Nur fuer den Server notwendig
  echo Update-Service Launcher kopieren
  find ../update-service/launcher/ -maxdepth 1 -type f -perm /a+x -exec cp {} $UPDATESERVICE_LAUNCHER_PATH/ \;
  echo Java cfg Launcher kopieren
  cp $COPY_PARAMS ../update-service/launcher/*.cfg $UPDATESERVICE_LAUNCHER_PATH/
  echo cfg, env und cmd kopieren
  cp $COPY_PARAMS ../update-service/launcher/bin/* $UPDATESERVICE_LAUNCHER_PATH/bin/
  echo Logs Update-Server Launcher kopieren
  cp $COPY_PARAMS ../update-service/launcher/logs/* $UPDATESERVICE_LAUNCHER_PATH/logs/
fi

if [ "$TYP" = "server" ]; then
  # Nur fuer den Server notwendig
  echo Service-Launcher kopieren
  find ../update-service/service/ -maxdepth 1 -type f -perm /a+x -exec cp {} $UPDATESERVICE_SERVICE_PATH/ \;
  echo Java cfg Update-Service kopieren
  cp $COPY_PARAMS ../update-service/service/*.cfg $UPDATESERVICE_SERVICE_PATH/
  echo xml Update-Service kopieren
  cp $COPY_PARAMS ../update-service/service/*.xml $UPDATESERVICE_SERVICE_PATH/
  echo Konfiguration Update-Service kopieren
  cp $COPY_PARAMS ../update-service/service/configuration/* $UPDATESERVICE_SERVICE_PATH/configuration/
  echo Logs zur Datenbank kopieren
  cp $COPY_PARAMS ../update-service/service/database/* $UPDATESERVICE_SERVICE_PATH/database/
  echo Logs Update-Service kopieren
  cp $COPY_PARAMS_SUBDIR ../update-service/service/logs/* $UPDATESERVICE_SERVICE_PATH/logs/
fi

if [ "$TYP" = "server" ]; then
  # Nur fuer den Server notwendig
  echo Startup Infos ESS kopieren
  cp $COPY_PARAMS ../plugins/applications/ess/* $ESS_BASE_PATH/
  echo Konfiguration ESS kopieren
  cp $COPY_PARAMS_SUBDIR ../plugins/applications/ess/config/* $ESS_BASE_PATH/config/
  echo Logs ESS kopieren
  cp $COPY_PARAMS_SUBDIR ../plugins/applications/ess/logs/* $ESS_BASE_PATH/logs/
  echo build.info ESS kopieren
  cp $COPY_PARAMS_SUBDIR ../plugins/applications/ess/plugins/build.info $ESS_BASE_PATH/plugins/
fi

echo Suche ZIP Programm
if [ -n "$(zip --help | grep "Copyright (c)")" ]; then
  echo ZIP gefunden
  zip $TMP_PATH.zip -r $TMP_PATH/
  echo ZIP Archiv erstellen
elif [ -n "$(7z --help | grep "Copyright (c)")" ]; then
  echo 7-ZIP gefunden
  7z a $TMP_PATH.7z $TMP_PATH/
  echo 7-ZIP Archiv erstellen
else
  echo ZIP Programm nicht gefunden. Benutze tar-gz
  tar -czvf $TMP_PATH.tar.gz $TMP_PATH/
  echo TAR-GZ Archiv erstellen
fi
rm -rf $TMP_PATH

exit 0