# Benoetigte JRE-Version
required_version="11.*"
# Verzeichnis des Skripts feststellen
BASEDIR="$(cd "$(dirname "$0")"; pwd)"

# Betriebssystem feststellen
case "$(uname -s)" in
  Linux*)
    os=linux
    ;;
  Darwin*)
    os=osx
    ;;
  Mac*)
    os=osx
    ;;
  *)
    echo "Betriebssystem nicht erkannt: Verwende Linux-Einstellungen"
    os=linux
    ;;
esac

# tmp-Ordner zum Entpacken des JRE feststellen
if [ -z "$TMPDIR" ]
then
  tmp_dir="/tmp"
else
  tmp_dir="$TMPDIR"
fi

# Testen ob tar zur Verfuegung steht
if ! [ -x "$(command -v tar)" ]
then
  # Bei osx-Betriebssystem hier abbrechen, da die Abfrage von 'java' nicht zuverlaessig ist
  if [ "$os" = "osx" ]; then
    echo "Zur Installation muss das Kommando 'tar' zur Verfuegung stehen." >&2
    exit 1
  fi
  
  # Bei Linux-Betriebssystem versuchen vorhandenes JRE zu verwenden
  if ! [ -x "$(command -v java)" ]; then
    echo "Zur Installation muss eines der Kommandos 'tar' oder 'java' (zu einem JRE in Version $required_version) zur Verfuegung stehen." >&2
    exit 1
  else
    echo "Kommando 'tar' konnte nicht gefunden werden. Versuche vorhandenes JRE zu nutzen."
    java_command=$(command -v java)
  fi
  
# Falls tar zur Verfuegung steht: Mitgeliefertes JRE in tmp-Ordner entpacken
elif [ "$os" = "osx" ]
then
  # Ordnernamen des einzelnen Ordners in der obersten Archivebene feststellen
  tmp_jre_dir=$(tar -tzf "$BASEDIR"/../jvm/jre64osx.tar.gz | head -1 | cut -f1 -d"/")
  # JRE im tmp-Ordner entpacken
  tar -C "$tmp_dir" -zxf "$BASEDIR"/../jvm/jre64osx.tar.gz
  # Pfad zur Java-Binary
  java_command="$tmp_dir"/"$tmp_jre_dir"/zulu-11.jre/Contents/Home/bin/java
else
  # Ordnernamen des einzelnen Ordners in der obersten Archivebene feststellen
  tmp_jre_dir=$(tar -tzf "$BASEDIR"/../jvm/jre64linux.tar.gz | head -1 | cut -f1 -d"/")
  # JRE im tmp-Ordner entpacken
  tar -C "$tmp_dir" -zxf "$BASEDIR"/../jvm/jre64linux.tar.gz
  # Pfad zur Java-Binary
  java_command="$tmp_dir"/"$tmp_jre_dir"/bin/java
fi


# Java-Version sicherheitshalber pruefen und falls OK ASV-Installer starten
java_version=$("$java_command" -version 2>&1 | awk -F '"' '/version/ {print $2}')
case "$java_version" in
$required_version)
    "$java_command" -Xmx512m -jar "$BASEDIR"/../ASV_install.jar "$@"
    ;;
*)
    echo "Das Java Runtime Environment von $java_command entspricht mit Version $java_version nicht der vorgegebenen Version $required_version. Installer kann nicht gestartet werden." >&2
    exit 1
    ;;
esac
