REM Script to call when a tool should be run in JRE - script finds JRE using SVP_HOME Vairiable and
REM runs using a variable called call_jvm_parameters - this script must be included in other tool scripts setting
REM these variables - it must not be run without this

REM Default JRE_HOME
if not exist %SVP_HOME% set SVP_HOME=%~dp0..

REM
REM Determine jre path
REM

set local_jre_cfg=%SVP_HOME%\jre.local.cfg
set base_jre_cfg=%SVP_HOME%\jre.cfg
set local_jre_path=%SVP_HOME%\jre.local
set base_jre_path=%SVP_HOME%\jre

setlocal enableextensions enabledelayedexpansion

if exist %local_jre_cfg% (
    set firstLine=1
    for /f "delims=" %%i in (%local_jre_cfg%) do (
        if !firstLine!==1 set local_jre_path=%%i
        set firstLine=0
    )
)

if exist %base_jre_cfg% (
    set firstLine=1
    for /f "delims=" %%i in (%base_jre_cfg%) do (
        if !firstLine!==1 set base_jre_path=%%i
        set firstLine=0
    )
)


if exist "%base_jre_path%\bin\java.exe" set content=%base_jre_path%\bin\java.exe
if exist "%local_jre_path%\bin\java.exe" set content=%local_jre_path%\bin\java.exe

REM
REM Run
REM

if exist "%content%" "%content%" !call_jvm_parameters!
if not exist "%content%" "%SVP_HOME%/jre/bin/java" !call_jvm_parameters!

endlocal