@echo off

REM
REM Migriert eine H2 DB. 
REM
REM A) VORBEREITUNG
REM 	1. Der Name der Datenbank-Datei sollte asv.mv.db sein.
REM 	2. Die Datenbank-Datei bitte im gleichen Ordner wie dieses Skript ablegen.
REM		3. Bitte in einem Unterordner lib/ die Jars h2-2.1.214.jar 
REM      (alternativ: de.isb.thirdparty.libs_1.0.0.jar aus ASV <= 2.21)
REM      und h2-2.2.222.jar ablegen.
REM
REM B) AUSFÜHRUNG
REM 	Der Aufruf dieses Skriptes ist wie folgt: migrateH2Database.bat <H2-DB-Passwort>.
REM 	Zum Ende der Reparatur wird vom Skript automatisch eine H2 Shell geöffnet. 
REM		Bitte dort den folgenden Befehl absetzen: 
REM			SHUTDOWN COMPACT;
REM 	Die darauf folgende Fehlermeldung bitte ignorieren und diesen Befehl absetzen:
REM			exit
REM
REM C) ERGEBNIS
REM 	Die migrierte DB-Datei heisst asv-migrated.mv.db und liegt im gleichen
REM		Ordner wie die ursprüngliche Datei.
REM

if %1.==. goto error
goto prepare

:error
echo Das Script muss folgendermassen aufgerufen werden: %0 H2-DB-Passwort.
echo Die Migration wird abgebrochen. 
exit /b

:prepare
set PASSWORD=%1
set USER=asv
set REPAIR_HOME=%~dp0
set LIB_DIR=%REPAIR_HOME%\lib
set DB_NAME=asv-by-empty
set DB_URL=%REPAIR_HOME%\%DB_NAME%
set DB_FILE_SUFFIX=.mv.db
set DB_FILE_NAME=%REPAIR_HOME%\%DB_NAME%%DB_FILE_SUFFIX%
set DB_RESTORED_NAME=asv-migrated
set DB_RESTORED_PATH=%REPAIR_HOME%\%DB_RESTORED_NAME%
set CLASSPATH_H2_199=%LIB_DIR%\h2-2.1.214.jar;%LIB_DIR%\de.isb.thirdparty.libs_1.0.0.jar
set CLASSPATH_H2_220=%LIB_DIR%\h2-2.2.222.jar

:checkJava
set _JAVACMD=%JAVACMD%
if "%JAVA_HOME%" == "" goto noJavaHome
if not exist "%JAVA_HOME%\bin\java.exe" goto noJavaHome
if "%_JAVACMD%" == "" set _JAVACMD=%JAVA_HOME%\bin\java.exe
goto checkDBFile

:noJavaHome
if "%_JAVACMD%" == "" set _JAVACMD=java.exe

:checkDBFile
if not exist "%DB_FILE_NAME%" goto noDbFile
goto repair

:noDbFile
echo Die DB Datei %DB_FILE_NAME% existiert nicht. 
echo Die Migration wird abgebrochen. 
exit /b

:repair
echo Die Migration beginnt. Es wird eine Backup-Datei erstellt.
"%_JAVACMD%" -cp "%CLASSPATH_H2_199%" org.h2.tools.Script -url jdbc:h2:%DB_URL% -user %USER% -password %PASSWORD% -script asv-script.zip -options compression zip
echo Die Backup-Datei wurde erfolgreich erstellt.

echo Es wird eine neue DB auf Grundlage des Backups erstellt.
"%_JAVACMD%" -cp "%CLASSPATH_H2_220%" org.h2.tools.RunScript -url jdbc:h2:file:%DB_RESTORED_PATH% -user %USER% -password %PASSWORD% -script asv-script.zip  -options compression zip FROM_1X
echo SHUTDOWN COMPACT; > shutdown.sql
"%_JAVACMD%" -cp "%CLASSPATH_H2_220%" org.h2.tools.RunScript -url jdbc:h2:file:%DB_RESTORED_PATH% -user %USER% -password %PASSWORD% -script shutdown.sql
del shutdown.sql

echo Die neue DB ist erstellt.
echo Die Migration war erfolgreich.
echo Die migrierte DB Datei ist %DB_RESTORED_PATH%.
